# Documentação do Sistema Vinci

## Visão Geral

O Sistema Vinci é uma plataforma web desenvolvida para gerenciar e visualizar dados comparativos de empresas. A plataforma possui três perfis de usuários (Administrador, Consultor e Cliente/Empresa), cada um com acesso a funcionalidades específicas.

## Perfis de Usuário

### Administrador
- Gerencia cadastros de faixas de faturamento, segmentos, setores, assuntos, atividades, empresas, usuários e perguntas
- Acesso total ao sistema

### Consultor
- Realiza pesquisas com empresas
- Visualiza e exporta dados comparativos
- Acesso às funcionalidades de pesquisa e visualização

### Cliente/Empresa
- Visualiza dados comparativos da própria empresa
- Acesso restrito às informações da própria empresa

## Funcionalidades Principais

### Sistema de Autenticação
- Login e logout
- Recuperação de senha
- Controle de acesso baseado em perfis

### Módulos de Cadastro (Administrador)
- Cadastro de faixas de faturamento
- Cadastro de segmentos
- Cadastro de setores
- Cadastro de assuntos
- Cadastro de atividades
- Cadastro de empresas
- Cadastro de usuários
- Cadastro de perguntas

### Módulo de Pesquisa (Consultor)
- Interface de pesquisa para seleção de empresas
- Filtros por segmento, setor e atividade
- Formulário de respostas para perguntas
- Salvamento de respostas no banco de dados

### Visualização e Exportação de Dados
- Dashboard para visualização de dados
- Gráficos para análise de resultados
- Comparativo entre empresas do mesmo segmento
- Exportação de dados em PDF e Excel

## Tecnologias Utilizadas

- **Backend**: Flask (Python)
- **Frontend**: HTML, CSS, JavaScript, Bootstrap
- **Banco de Dados**: SQLAlchemy
- **Visualização de Dados**: Matplotlib, Seaborn
- **Exportação**: ReportLab (PDF), OpenPyXL (Excel)

## Estrutura do Projeto

```
vinci_platform/
├── src/
│   ├── models/
│   │   ├── user.py
│   │   └── ...
│   ├── routes/
│   │   ├── auth.py
│   │   ├── admin_*.py
│   │   ├── consultor_*.py
│   │   ├── cliente.py
│   │   └── visualizacao.py
│   ├── static/
│   │   ├── css/
│   │   ├── js/
│   │   └── img/
│   ├── templates/
│   │   ├── auth/
│   │   ├── admin/
│   │   ├── consultor/
│   │   ├── cliente/
│   │   ├── visualizacao/
│   │   └── base.html
│   └── main.py
└── requirements.txt
```

## Guia de Uso

### Para Administradores

1. Acesse o sistema com suas credenciais de administrador
2. No dashboard, você terá acesso a todos os módulos de cadastro
3. Comece cadastrando as informações básicas: faixas de faturamento, segmentos, setores, assuntos e atividades
4. Cadastre as empresas que participarão das pesquisas
5. Cadastre os usuários do sistema, definindo seus perfis
6. Cadastre as perguntas que serão utilizadas nas pesquisas

### Para Consultores

1. Acesse o sistema com suas credenciais de consultor
2. No dashboard, selecione "Pesquisas" para iniciar uma nova pesquisa
3. Selecione a empresa que deseja pesquisar
4. Aplique filtros por setor, assunto ou atividade, se necessário
5. Preencha as respostas para as perguntas exibidas
6. Salve as respostas ao finalizar
7. Para visualizar os dados, acesse o histórico de pesquisas e selecione "Visualizar Dados"
8. Para exportar os dados, utilize as opções de exportação em PDF ou Excel

### Para Clientes/Empresas

1. Acesse o sistema com suas credenciais de cliente
2. No dashboard, você verá os dados da sua empresa
3. Visualize os gráficos e dados comparativos
4. Utilize as opções de exportação para obter relatórios em PDF ou Excel

## Manutenção e Suporte

Para suporte técnico ou dúvidas sobre o sistema, entre em contato com a equipe de desenvolvimento.

## Requisitos do Sistema

- Navegador web moderno (Chrome, Firefox, Edge, Safari)
- Conexão com a internet
- Resolução de tela mínima recomendada: 1280x720
