from flask import Blueprint, render_template
from flask_login import login_required, current_user

cliente_bp = Blueprint('cliente', __name__)

@cliente_bp.route('/dashboard')
@login_required
def dashboard():
    # Verificar se o usuário é cliente
    if current_user.tipo_perfil != 'cliente':
        return render_template('errors/403.html'), 403
    
    return render_template('cliente/dashboard.html')
