# Instruções de Implantação - Sistema Vinci

Este documento contém as instruções para implantação e configuração inicial do Sistema Vinci.

## Requisitos do Sistema

- Python 3.8 ou superior
- Pip (gerenciador de pacotes Python)
- Banco de dados MySQL (opcional, pode usar SQLite para testes)
- Navegador web moderno

## Passos para Implantação

### 1. Preparação do Ambiente

1. Extraia o arquivo `vinci_platform.zip` em um diretório de sua escolha
2. Crie um ambiente virtual Python:
   ```
   python -m venv venv
   ```
3. Ative o ambiente virtual:
   - Windows: `venv\Scripts\activate`
   - Linux/Mac: `source venv/bin/activate`

### 2. Instalação de Dependências

1. Instale as dependências necessárias:
   ```
   pip install -r requirements.txt
   ```

### 3. Configuração do Banco de Dados

1. Por padrão, o sistema usa SQLite para facilitar a implantação inicial
2. Para usar MySQL, descomente e configure a linha no arquivo `src/main.py`:
   ```python
   app.config['SQLALCHEMY_DATABASE_URI'] = f"mysql+pymysql://{os.getenv('DB_USERNAME', 'root')}:{os.getenv('DB_PASSWORD', 'password')}@{os.getenv('DB_HOST', 'localhost')}:{os.getenv('DB_PORT', '3306')}/{os.getenv('DB_NAME', 'vinci_db')}"
   ```
3. Crie o banco de dados:
   ```
   mysql -u root -p -e "CREATE DATABASE vinci_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
   ```

### 4. Inicialização do Banco de Dados

1. Execute o script de inicialização para criar as tabelas e inserir dados iniciais:
   ```
   python init_db.py
   ```
2. Este script criará um usuário administrador padrão:
   - Email: admin@vinci.com
   - Senha: admin123

### 5. Execução da Aplicação

1. Inicie o servidor de desenvolvimento:
   ```
   python src/main.py
   ```
2. Acesse a aplicação em seu navegador:
   ```
   http://localhost:5000
   ```

### 6. Configuração para Produção

Para ambientes de produção, recomendamos:

1. Usar um servidor WSGI como Gunicorn:
   ```
   pip install gunicorn
   gunicorn -w 4 -b 0.0.0.0:5000 "src.main:app"
   ```
2. Configurar um proxy reverso (Nginx ou Apache)
3. Usar variáveis de ambiente para configurações sensíveis
4. Configurar HTTPS para segurança

## Primeiros Passos Após a Implantação

1. Faça login com o usuário administrador padrão
2. Altere a senha do administrador padrão
3. Cadastre os dados básicos do sistema:
   - Faixas de faturamento
   - Segmentos
   - Setores
   - Assuntos
   - Atividades
4. Cadastre as empresas que participarão das pesquisas
5. Cadastre os usuários do sistema (consultores e clientes)
6. Cadastre as perguntas para as pesquisas

## Suporte e Manutenção

Para suporte técnico ou dúvidas sobre a implantação, entre em contato com a equipe de desenvolvimento.

---

© 2025 Sistema Vinci - Todos os direitos reservados
