from flask import Blueprint, render_template
from flask_login import login_required, current_user

consultor_bp = Blueprint('consultor', __name__)

@consultor_bp.route('/dashboard')
@login_required
def dashboard():
    # Verificar se o usuário é consultor
    if current_user.tipo_perfil != 'consultor':
        return render_template('errors/403.html'), 403
    
    return render_template('consultor/dashboard.html')
